from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, List


@dataclass
class ArticleItem(Model):
    label: str = Str("文章标题").eg("手把手教你看懂电费单")
    url: str = Str("文章内容(链接)").eg("https://mp.weixin.qq.com/s/Bm_SnDtqkkjb_zw-M11F7A")


@dataclass
class ArticleListResp(Model):
    """
    关于我们硬件信息统计
    """

    article_list: list = List().items(ArticleItem)
