from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Opt, List, Int


@dataclass
class ForecastReq(Model):
    cid: Cid = Opt(Cid)
    proxy_id: int = Opt(Int("代理id").eg(1))
    start: str = Str("开始时间").eg("2020-09-27 00:00:00")
    end: str = Str("结束时间").eg("2020-09-27 23:59:59")
    cids: list = Opt(List().items(Int("工厂id").eg(54)))


@dataclass
class LoadValue(Model):
    slots: list = List("slots").eg(["00:00", "00:15", "00:30"])
    value: list = List("时间段对应的值").eg([0.1, 0.2, 0.3])


@dataclass
class ForecastResp(Model):
    pred_data: LoadValue = Opt(LoadValue)
    real_data: LoadValue = Opt(LoadValue)
    deviation_list: list = List("偏差").eg(["3.45%", "3.46%", "3.47%"])
    max_deviation: list = List("最大偏差").eg(["25%", "01:30"])
    min_deviation: list = List("最小偏差").eg(["0.2%", "11:30"])
    avg_deviation: str = Str("平均偏差").eg("3.0%")
    total_deviation: str = Str("总量偏差").eg("1.5%")
    # 知电U管理版本-负荷分析
    pred_power_list: LoadValue = Opt(LoadValue)
    real_power_list: LoadValue = Opt(LoadValue)
    deviation_power_list: list = List("电量偏差").eg(["3.45%", "3.46%", "3.47%"])
