from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, Float, Str, List, Dict


@dataclass
class CountInfoProxyResp(Model):
    total_cid: int = Opt(Int("接入用户").eg(20))
    total_monitor: int = Opt(Int("监测点位").eg(80))
    safe_operation_days: int = Opt(Int("安全运行天数").eg(11))
    total_power: float = Opt(Float("累计监测用电").eg(96000))
    total_alarm: int = Opt(Int("累计报警次数").eg(5))
    co2: float = Opt(Float("日均碳排放").eg(9600.11))


@dataclass
class ProxySecurityLevelCntReq(Model):
    product: int = Int("产品类型").eg(3)
    proxy_id: int = Opt(Int("代理id").eg(1))
    cid: int = Opt(Int("工厂id").eg(66))


@dataclass
class ProxySecurityLevelCntResp(Model):
    high_cnt: int = Int("高风险的工厂个数").eg(20)
    pretty_high_cnt: int = Int("较高风险的工厂个数").eg(10)
    medium_cnt: int = Int("中等风险的工厂个数").eg(11)
    pretty_low_cnt: int = Int("较低风险的工厂个数").eg(1)
    security_cnt: int = Int("无风险的工厂个数").eg(78)


@dataclass
class AlarmLevelCnt(Model):
    first_alarm_cnt: int = Int("一级报警数目").eg(20)
    second_alarm_cnt: int = Int("二级报警数目").eg(10)
    third_alarm_cnt: int = Int("三级报警数目").eg(11)


@dataclass
class AlarmContentCnt(Model):
    temperature_cnt: int = Int("温度内容报警数目").eg(1)
    residual_current_cnt: int = Int("漏电流内容报警数目").eg(78)
    electric_param_cnt: int = Int("电参数内容报警数目").eg(78)


@dataclass
class RtrResp(Model):
    alarm_level_cnt: AlarmLevelCnt = AlarmLevelCnt
    alarm_content_cnt: AlarmContentCnt = AlarmContentCnt
    ranking: list = List("排名").eg(
        [{"name": "变压器#1", "alarm_count": 12, "first": 4, "second": 3,
          "third": 5}]
    )


@dataclass
class CmResp(Model):
    safe: dict = Dict("安全").eg(
        {"temperature_cnt": "温度", "residual_current_cnt": "漏电流"})
    power: dict = Dict("用电").eg(
        {"lr_cnt": "负载率", "power_factor_cnt": "功率因数",
         "under_u_cnt": "欠压", "over_u_cnt": "过压", "over_i_cnt": "过流"})


@dataclass
class ApcResp(Model):
    today_alarm: dict = Dict("今日报警").eg(
        {
            "first_cnt": "1级报警数",
            "second_cnt": "2级报警数",
            "third_cnt": "3级报警数",
            "total_cnt": "总报警数"
         }
    )
    avg_price: dict = Dict("平均电价").eg(
        {
            "yesterday": "昨天",
            "last_7_day": "近7天",
            "last_30_day": "近30天"
        }
    )
    real_total_p: float = Float("实时总负荷").eg(1304.11)
    real_costtl: float = Float("实时功率因数").eg(0.93)
    today_avg_price: float = Float("今日平均电价").eg(0.63)


@dataclass
class AlarmTimeDistribution(Model):
    day_alarm_cnt: int = Int("白天报警数").eg(1)
    night_alarm_cnt: int = Int("晚上报警数").eg(78)
    morning_alarm_cnt: int = Int("凌晨报警数").eg(78)


@dataclass
class ProxyAlarmPercentageCntResp(Model):
    alarm_level_cnt: AlarmLevelCnt = AlarmLevelCnt
    alarm_content_cnt: AlarmContentCnt = AlarmContentCnt
    alarm_time_cnt: AlarmTimeDistribution = AlarmTimeDistribution


@dataclass
class PowerItem(Model):
    s: float = Float("s-尖").eg(123.2)
    v: float = Float("v-谷").eg(123.2)
    p: float = Float("p-峰").eg(123.2)
    f: float = Float("f-平").eg(123.2)


@dataclass
class RegAlarmCnt(Model):
    illegal_eleprod: int = Int("违规电器报警数").eg(20)
    high_p_eleprod: int = Int("大功率电器报警数").eg(10)
    overuse_eleprod: int = Int("用电超载报警数").eg(11)
    electric_quantity: int = Int("电能品质报警数").eg(12)
    ele_car_battery: int = Int("电动车电池报警数").eg(12)


@dataclass
class CidInfoItem(Model):
    today_alarm_info: AlarmLevelCnt = AlarmLevelCnt
    today_power_info: PowerItem = PowerItem
    safe_run_days: int = Int("安全运行天数").eg(45)
    electric_index: float = Float("安全指数").eg(67.02)
    electric_score: float = Float("安全报警分").eg(1)
    safe_rank: int = Int("安全排名").eg(1)
    health_index: float = Float("健康指数").eg(89.02)
    health_rank: int = Int("健康排名").eg(2)
    company_cnt: int = Int("工厂个数").eg(10)
    company_name: str = Str("工厂名称").eg("福田高铁站")
    today_alarm_cnt: int = Int("今日报警数").eg(20)
    longitude: float = Float("经度").eg(114.054533)
    latitude: float = Float("纬度").eg(22.52179)
    reg_today_alarm_info: RegAlarmCnt = RegAlarmCnt


@dataclass
class ProxyInfoItem(Model):
    district_code: str = Str("区号").eg("440305")
    cid_info_list: list = List("报警信息").items(CidInfoItem)
    longitude: float = Float("经度").eg(114.054533)
    latitude: float = Float("纬度").eg(22.52179)


@dataclass
class ProxyIndexMapResp(Model):
    proxy_info: list = List("代理信息数组").items(ProxyInfoItem)


@dataclass
class CountInfoSduResp(Model):
    total_tenant: int = Opt(Int("接入租户").eg(20))
    online_rate: float = Opt(Float("在线率").eg(0.8))
    safe_operation_days: int = Opt(Int("安全运行天数").eg(11))
    total_power: float = Opt(Float("累计监测用电").eg(96000))
    total_alarm: int = Opt(Int("累计报警次数").eg(5))


@dataclass
class AlarmItem(Model):
    name: str = Str("报警位置").eg("演示楼栋#1")
    alarm_cnt: int = Int("报警数")


@dataclass
class AlarmDistributionResp(Model):
    alarm_categories: RegAlarmCnt = RegAlarmCnt


@dataclass
class AlarmRankingReq(Model):
    date_type: str = Str("时间类型->day/month").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(3)


@dataclass
class AlarmRankingResp(Model):
    position_alarm_info: list = List("位置报警统计").items(AlarmItem)


@dataclass
class AipResp(Model):
    total_cid: int = Opt(Int("总接入用户").eg(20))
    total_monitor: int = Opt(Int("总接入监测点").eg(80))
    total_power: float = Opt(Float("累计监测电量").eg(96000))
    total_run_day: int = Opt(Int("总服务时长").eg(30))


@dataclass
class CisResp(Model):
    total_tenant: int = Opt(Int("接入住户").eg(20))
    online_rate: float = Opt(Float("在线率").eg(0.8))
    safe_day: float = Opt(Float("平均安全运行").eg(11.1))
    total_power: float = Opt(Float("累计监测用电").eg(96000))
    total_alarm: int = Opt(Int("累计报警次数").eg(5))


@dataclass
class CisReq(Model):
    product: int = Int("产品类型").eg(4)
    cid: int = Opt(Int("工厂id").eg(113))


@dataclass
class IycResp(Model):
    total_point: int = Opt(Int("监测对象").eg(20))
    air_quality: int = Opt(Int("空气优").eg(10))
    safe_operation_days: int = Opt(Int("安全运行天数").eg(11))
    total_water: float = Opt(Float("累计降尘用水").eg(132.80))
    total_kwh: int = Opt(Int("累计降尘用电").eg(12211.24))


@dataclass
class IycmResp(Model):
    safety_index: int = Int("用电安全指数").eg(89)
    today_alarm: int = Int("今日报警数").eg(5)
    total_max_pm25: float = Float("今日最高PM2.5").eg(27.12)
    center_address: list = List("工厂中心点坐标").eg([113.972624, 22.519019])
    range_address: list = List("工厂范围坐标").eg(
        [[113.970806, 22.519089], [113.972067, 22.518356],
         [113.973292, 22.51905], [113.973023, 22.519234]])


@dataclass
class AsiResp(Model):
    first_alarm_cnt: int = Int("一级报警数目").eg(20)
    second_alarm_cnt: int = Int("二级报警数目").eg(10)
    third_alarm_cnt: int = Int("三级报警数目").eg(11)
    alarm_score: float = Float("报警分").eg(8.11)
    electric_use_score: int = Int("用电安全指数").eg(62)
    safety_ratio: str = Str("安全风险系数").eg("风险较低")


@dataclass
class HsiResp(Model):
    health_index: int = Int("健康指数").eg(62)
    health_status: str = Str("健康状态").eg("状态优")
    v_dev: int = Int("电压偏差评分")
    freq_dev: int = Int("频率偏差评分")
    ubl: int = Int("三相[电压]不平衡评分")
    costtl: int = Int("功率因数评分")
    thdu: int = Int("谐波畸变评分")
    lf: int = Int("负载率评分")


@dataclass
class AiiResp(Model):
    health_index: dict = Dict("健康指数").eg(
        {"value": 62, "desc": "当前健康状况良好，请继续保持！"})
    safe_index: dict = Dict("用电安全指数").eg(
        {"value": 62, "des": "当前健康状况良好，请继续保持！"})
    carbon_index: dict = Dict("碳排指数").eg(
        {"value": 62, "desc": "当前健康状况良好，请继续保持！"})
    economic_index: dict = Dict("经济指数").eg(
        {"value": 62, "desc": "当前健康状况良好，请继续保持！"})
