from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Float, Opt


@dataclass
class ProxyOpReq(Model):
    proxy_id: int = Opt(Int("代理id").eg(1))
    cids: list = List().items(Int("工厂id").eg(42))
    month: str = Str("月份").eg("2020-12")
    status: list = Opt(List().items(Str("状态筛选, 传对应的状态过来").eg("减免")))
    page_size: int = Opt(Int("一页多少条").eg(10))
    page_num: int = Opt(Int("第几页").eg(1))
    sort_field: str = Opt(Str("排序字段").eg("power_factor/save_charge"))
    sort_direction: str = Opt(Str("排序方向").eg("asc/desc"))


@dataclass
class ProxyPowerFactorPageItem(Model):
    cid: int = Int("公司id").eg(68)
    company_name: str = Str("公司名称").eg("群众文化中心")
    inline_id: int = Int("进线id").eg(17)
    inline_name: str = Str("进线名称").eg("1#进线")
    power_factor: float = Float("功率因素").eg(0.7)
    status: str = Str("状态").eg("减免")
    save_charge: float = Float("月力调电费, 单位元").eg(10000)


@dataclass
class ProxyPowerFactorListResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyPowerFactorPageItem)


@dataclass
class ProxyPowerFactorSummarryResp(Model):
    total_cnt: int = Int("监测点数").eg(10)
    unqualified_cnt: int = Int("不合格监测点数").eg(10)
    first_level_cnt: int = Int(">=0.95").eg(10)
    second_level_cnt: int = Int(">=0.9 && < 0.95").eg(10)
    third_level_cnt: int = Int(">=0.85 && < 0.9").eg(10)
    fourth_level_cnt: int = Int(">=0.8 && < 0.85").eg(10)
    fifth_level_cnt: int = Int("<0.8").eg(10)


@dataclass
class ProxyMdSpacePageItem(Model):
    cid: int = Int("公司id").eg(68)
    company_name: str = Str("公司名称").eg("群众文化中心")
    inline_id: int = Int("进线id").eg(17)
    inline_name: str = Str("进线名称").eg("1#进线")
    inline_tc: float = Float("总容量").eg(0.7)
    tc_runtime: float = Float("运行容量").eg(0.7)
    status: str = Str("状态").eg("有空间")
    save_charge: float = Float("容改需月节费, 单位元").eg(10000)


@dataclass
class ProxyMdSpaceListResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyMdSpacePageItem)


@dataclass
class ProxyMdSpaceSummarryResp(Model):
    total_cnt: int = Int("总接入数").eg(10)
    exits_space_cnt: int = Int("存在空间数").eg(10)
    big_space_cnt: int = Int("空间较大").eg(10)
    proper_space_cnt: int = Int("空间适中").eg(10)
    small_space_cnt: int = Int("空间较小").eg(10)
    no_space_cnt: int = Int("无空间").eg(10)


@dataclass
class ProxyPowerSaveItem(Model):
    cid: int = Int("公司id").eg(68)
    company_name: str = Str("公司名称").eg("群众文化中心")
    inline_id: int = Int("进线id").eg(17)
    inline_name: str = Str("进线名称").eg("1#进线")
    inline_tc: float = Float("总容量").eg(0.7)
    tc_runtime: float = Float("运行容量").eg(0.7)
    avg_load_rate: float = Float("平均负载率").eg(0.6787)
    cos_loss_rate: float = Float("损耗占比").eg(0.1787)
    save_charge: float = Float("理论月节费, 单位元").eg(10000)


@dataclass
class ProxyPowerSaveListResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyPowerSaveItem)


@dataclass
class ProxyPowerSaveSummaryResp(Model):
    total_cnt: int = Int("总接入数").eg(10)
    exits_space_cnt: int = Int("存在空间数").eg(10)
    big_space_cnt: int = Int("空间较大").eg(10)
    proper_space_cnt: int = Int("空间适中").eg(10)
    small_space_cnt: int = Int("空间较小").eg(10)
    no_space_cnt: int = Int("无空间").eg(10)


@dataclass
class ProxyPcvfPageItem(Model):
    cid: int = Int("公司id").eg(68)
    company_name: str = Str("公司名称").eg("群众文化中心")
    inline_id: int = Int("进线id").eg(17)
    inline_name: str = Str("进线名称").eg("1#进线")
    power: float = Float("电量，单位kwh").eg(0.7)
    charge: float = Float("电费, 单位元").eg(0.7)
    avg_price: float = Float("平均电价, 单位元/kwh").eg(0.7)
    pcvf_index: float = Float("移峰填谷指数").eg(78)
    save_charge: float = Float("理论月节费, 单位元").eg(10000)


@dataclass
class ProxyPcvfListResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyPowerSaveItem)


@dataclass
class ProxyPowerSaveSummaryResp(Model):
    total_cnt: int = Int("总接入数").eg(10)
    exits_space_cnt: int = Int("存在空间数").eg(10)
    big_space_cnt: int = Int("空间较大").eg(10)
    proper_space_cnt: int = Int("空间适中").eg(10)
    small_space_cnt: int = Int("空间较小").eg(10)
    no_space_cnt: int = Int("无空间").eg(10)


@dataclass
class OptimizationInfo(Model):
    can_optimiz_cnt: int = Int("存在优化空间数")
    save_charge: float = Float("节约费用")


@dataclass
class ProxyElectricOpSummaryResp(Model):
    power_factor: OptimizationInfo = OptimizationInfo
    md_space: OptimizationInfo = OptimizationInfo
    pcvf: OptimizationInfo = OptimizationInfo
    power_save: OptimizationInfo = OptimizationInfo
