from pot_libs.sanic_api import summary
from urllib import parse
from pot_libs.common.components.responses import Success
from unify_api.modules.elec_charge.components.syncretize_energy_cps import \
    EssEvaluateReq, PvEvaluateReq, PvEvaluateTwoResp, \
    PvEvaluateComputeReq, PvEvaluateComputeResp, EssEvaluateComputeReq, \
    EssEvaluateComputeResp, ElectrovalenceSettingReq, ElectrovalenceReq, \
    ElectrovalenceResp
from unify_api.modules.elec_charge.service.syncretize_energy_services \
    import pv_evaluate_service, pv_evaluate_compute_service, \
    ess_evaluate_service, electrovalence_setting_service, \
    ess_evaluate_compute_service, electrovalence_service


@summary('综合能源-光伏-页面')
async def post_pv_evaluate(req, body: PvEvaluateReq) -> PvEvaluateTwoResp:
    cid = body.cid
    start = body.start
    end = body.end
    return await pv_evaluate_service(cid, start, end)


@summary('综合能源-光伏-测算')
async def post_pv_evaluate_compute(req, body: PvEvaluateComputeReq) \
        -> PvEvaluateComputeResp:
    params = req.json
    url = "/unify-api/elec-charge/syncretize-energy/download-pv-evaluate-compute?" + parse.urlencode(params)
    return await pv_evaluate_compute_service(url=url, **params)


@summary('综合能源-光伏-测算表-下载')
async def get_download_pv_evaluate_compute(req):
    params = {
        "cid": req.args.get("cid"),
        "start": req.args.get("start"),
        "end": req.args.get("end"),
        "area_conversion_ratio": float(req.args.get("area_conversion_ratio")),
        "capacity_per_meter": float(req.args.get("capacity_per_meter")),
        "install_space": float(req.args.get("install_space")),
        "self_use_ratio": float(req.args.get("self_use_ratio")),
        "internet_ratio": float(req.args.get("internet_ratio")),
        "efficiency": float(req.args.get("efficiency")),
        "evaluate_year": int(req.args.get("evaluate_year")),
        "rmb_per_w": float(req.args.get("rmb_per_w")),
        "maintenance_per_wp": float(req.args.get("maintenance_per_wp")),
        "coal_in_grid": float(req.args.get("coal_in_grid")),
    }
    return await pv_evaluate_compute_service(download=1, **params)


@summary('综合能源-储能')
async def post_ess_evaluate(req, body: EssEvaluateReq) -> PvEvaluateTwoResp:
    cid = body.cid
    start = body.start
    end = body.end
    work_day = int(body.work_day)
    return await ess_evaluate_service(cid, start, end, work_day)


@summary('综合能源-储能-测算')
async def post_ess_evaluate_compute(req, body: EssEvaluateComputeReq) \
        -> EssEvaluateComputeResp:
    params = req.json
    url = "/unify-api/elec-charge/syncretize-energy/download-ess-evaluate-compute?" + parse.urlencode(params)
    return await ess_evaluate_compute_service(url=url, **params)


@summary('综合能源-储能-测算-下载')
async def get_download_ess_evaluate_compute(req):
    params = {
        "cid": req.args.get("cid"),
        "start": req.args.get("start"),
        "end": req.args.get("end"),
        "rule": int(req.args.get("rule")),
        "install_capacity": float(req.args.get("install_capacity")),
        "pcs_type": float(req.args.get("pcs_type")),
        "decay_rate": float(req.args.get("decay_rate")),
        "DOD": float(req.args.get("DOD")),
        "year_use_days": int(req.args.get("year_use_days")),
        "subsidy_year": int(req.args.get("subsidy_year")),
        "maintenance_ratio_per_year":
            float(req.args.get("maintenance_ratio_per_year")),
        "epc_price": float(req.args.get("epc_price")),
        "kwh_subsidy": float(req.args.get("kwh_subsidy")),
    }
    return await ess_evaluate_compute_service(download=1, **params)


@summary('设置电价')
async def post_electrovalence_setting(req, body: ElectrovalenceSettingReq) \
        -> Success:
    cid = body.cid
    price_md = body.price_md
    price_tc = body.price_tc
    std_cos = body.std_cos
    electrovalence = body.electrovalence
    return await electrovalence_setting_service(cid, price_md, price_tc,
                                                std_cos, electrovalence)


@summary('查看电价')
async def post_electrovalence(req, body: ElectrovalenceReq) \
        -> ElectrovalenceResp:
    cid = body.cid
    return await electrovalence_service(cid)

