def get_electric_index(alarm_score):
    """
    根据报警分，返回用电安全指数
    :param alarm_score:
    :return:
    """
    if 0 <= alarm_score < 2:
        electric_use_score = -10 * alarm_score + 100
    elif 2 <= alarm_score < 5:
        electric_use_score = (-10 / 3) * alarm_score + (80 + 20 / 3)
    elif 5 <= alarm_score < 10:
        electric_use_score = -2 * alarm_score + 80
    elif 10 <= alarm_score < 20:
        electric_use_score = -6 * alarm_score + 120
    else:
        electric_use_score = 0
    return round(electric_use_score)


def carbon_index(energy_deviation):
    """根据能耗偏差，返回碳排指数"""
    if energy_deviation > 0.1:
        index_value = 100
    elif -0.1 < energy_deviation <= 0.1:
        index_value = 200 * energy_deviation + 80
    elif -0.2 < energy_deviation <= -0.1:
        index_value = 600 * energy_deviation + 120
    else:
        index_value = 0
    return round(index_value)
