from pot_libs.es_util.es_utils import EsUtil
from pot_libs.logger import log
from unify_api.utils.time_format import convert_es_str
from pot_libs.mysql_util.mysql_util import MysqlUtil

point_15min_index = "poweriot_point_15min_index"


async def query_point_15min_index(date_start, date_end, point_id):
    """point点某一天96个点数据"""
    start_es = convert_es_str(date_start)
    end_es = convert_es_str(date_end)

    query_body = {
        "size": 100,
        "_source": ["pttl_mean", "quarter_time"],
        "query": {
            "bool": {
                "must": [
                    {
                        "term": {
                            "pid": point_id
                        }
                    },
                    {
                        "range": {
                            "quarter_time": {
                                "gte": start_es,
                                "lte": end_es
                            }
                        }
                    }
                ]
            }
        }
    }
    log.info(query_body)
    async with EsUtil() as es:
        es_re = await es.search(body=query_body, index=point_15min_index)
    return es_re


async def query_point_15min_index_aggs_pid(date_start, date_end, point_list):
    """
    1. 根据pid聚合
    2. 根据15分钟聚合
    3. 拿到hits数据
    """
    start_es = convert_es_str(date_start)
    end_es = convert_es_str(date_end)

    query_body = {
        "size": 0,
        "query": {
            "bool": {
                "must": [
                    {
                        "terms": {
                            "pid": point_list
                        }
                    },
                    {
                        "range": {
                            "quarter_time": {
                                "gte": start_es,
                                "lte": end_es
                            }
                        }
                    }
                ]
            }
        },
        "aggs": {
            "points": {
                "terms": {
                    "field": "pid",
                    "size": 1000
                },
                "aggs": {
                    "quarter_time": {
                        "date_histogram": {
                            "field": "quarter_time",
                            "interval": "15m",
                            "time_zone": "+08:00",
                            "format": "yyyy-MM-dd HH:mm:ss"
                        },
                        "aggs": {
                            "pttl_mean": {
                                "top_hits": {
                                    "size": 1,
                                    "_source": ["pttl_mean", "quarter_time"]
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    log.info(query_body)
    async with EsUtil() as es:
        es_re = await es.search_origin(body=query_body,
                                       index=point_15min_index)
    return es_re["aggregations"]["points"]["buckets"]


async def sql_point_15min_index_new15(start, end, pid):
    sql = f"SELECT pttl_mean, create_time FROM `point_15min_electric` " \
          f"where pid=%s and create_time BETWEEN '{start}' and '{end}'"
    async with MysqlUtil() as conn:
        datas = await conn.fetchall(sql, args=(pid,))
    return datas
