from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, List, Int, Opt
from unify_api.utils.response_code import DbErr


@dataclass
class CompanyRequest(Model):
    province: str = Opt(Str("选择的省份").eg("全国"))
    input_str: str = Opt(Str("查找框输入的内容").eg("微众"))
    cid_list: list = Opt(List('cid列表').eg([44, 56, 59]))
    product: int = Opt(Int("产品类型 3-安电u管理 4-识电U"))
    proxy_id: int = Opt(Int("代理id 当product为管理版时传"))


@dataclass
class SelectCompany(Model):
    cid: Cid
    shortname: str = Str('工厂名').eg('兴龙轮毂')
    fullname: str = Str('工厂全名称').eg('秦皇岛中秦兴龙轮毂有限公司')


@dataclass
class CompanyResponse(Model, DbErr):
    select_company: list = List('搜索工厂结果').items(SelectCompany)


@dataclass
class CmReq(Model):
    cid: int = Int("公司id").eg(66)


@dataclass
class CmRes(Model):
    cid: int = Int().eg(66)
    model_url: str = Str().eg(
        "https://cdn.soejh.com/project-3d/touzidasha/src/index.min.js")
    direction: str = Str("vertical-垂直/horizontal-水平").eg("vertical")
