import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "month": "2020-10",
        "cids": [66, 73, 74],
        "product": 0,
        "page_size": 10,
        "page_num": 1,
        "sort_field": "health_exp, volt_hr, curr_hr, ubl, ibl, volt_dev, "
                      "freq_dev",
        "sort_direction": "desc, asc"
    },
    {
        "month": "2020-10",
        "cids": [66, 73, 74],
        "product": 0,
        "page_size": 20,
        "page_num": 1,
        "sort_field": "health_exp, volt_hr, curr_hr, ubl, ibl, volt_dev, "
                      "freq_dev",
        "sort_direction": "desc, asc"
    }
])
@pytest.mark.asyncio
async def test_health_count_info(data):
    """
    安电u管理版本-用电健康-上方统计数据接
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric/proxy-health"
            f"/health-count-info",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["total_point_cnt"],
                resp_str["data"]["health_level"],
                resp_str["data"]["health_problem"]])


@pytest.mark.parametrize('data', [
    {
        "month": "2020-10",
        "cids": [66, 73, 74],
        "product": 0,
        "page_size": 10,
        "page_num": 1,
        "sort_field": "health_exp, volt_hr, curr_hr, ubl, ibl, volt_dev, "
                      "freq_dev",
        "sort_direction": "desc, asc"
    },
])
@pytest.mark.asyncio
async def test_health_list(data):
    """安电u管理版-用电健康-获取月度列表数据"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric/proxy-health"
            f"/health-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total"] == len(resp_str["data"]["rows"])
