from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, Str, List, Int, Dict, Opt


@dataclass
class BasicInfoReq(Model):
    # cid: int = Int("工厂id").eg(78)
    # cid: int = Opt(Int("工厂id").eg(78))
    page_size: int = Opt(Int("页面大小").eg(10))
    page_num: int = Opt(Int("当前页面").eg(1))


@dataclass
class BasicInfoResp(Model):
    rows: list = List("基本信息").eg({
        "pid": "监测点id",
        "mtid": "监测点id",
        "equipment_address": "设备地址",
        "equipment_code": "设备编码",
        "root_address": "房屋地址",
        "longitude": "经度",
        "latitude": "纬度",
        "insurer": "王五",
        "insurer_phone": "责任人电话"
    })
    total: int = Int("总量")


@dataclass
class StbDataResp(Model):
    rows: str = Str("基本信息").eg("")
    total: int = Int("cid").eg(78)


@dataclass
class StbDataReq(Model):
    type: str = Str("类型").eg("appliance or electric or soe")
    # cid: int = Int("cid").eg(78)


@dataclass
class SupplementReq(Model):
    cid: int = Int("cid").eg(78)
    start: str = Str("开始时间").eg("2021-12-29 00:00:00")
    end: str = Str("开始时间").eg("2021-12-29 06:00:00")
    type: str = Str("类型").eg("appliance or electric")
