from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, Float, Dict, Str, Opt


@dataclass
class UsaReq(Model):
    inline_id: int = Int("进线id").eg(17)
    cell_price: float = Float("电池单价").eg(2000)
    pcs_price: float = Float("PCS单价").eg(300)
    other_ttl_charge: float = Float("其他投资费用").eg(0)
    pcs_efficiency: int = Int("PCS转换效率").eg(95)
    bat_efficiency: int = Int("电池充放电效率").eg(95)
    decay_rate: float = Float("衰效率").eg(5.0)
    dod: int = Int("放电深度").eg(90)
    year_use_days: float = Float("年可利用时间").eg(330)
    charge_c_rate: float = Float("充放电倍率").eg(0.8)


@dataclass
class UseResp(Model):
    cell_price: int = Int("电池单价")
    pcs_price: int = Int("PCS单价")
    other_ttl_charge: int = Int("其他投资费用")
    pcs_efficiency: int = Int("PCS转换效率")
    bat_efficiency: int = Int("电池充放电效率")
    decay_rate: float = Float("衰效率")
    dod: int = Int("放电深度")
    year_use_days: int = Int("年可利用时间")
    charge_c_rate: float = Float("充放电倍率")


@dataclass
class UsaResp(Model):
    capacity: dict = Opt(Dict("容量规模"))
    economic_evaluate: dict = Opt(Dict("经济测算"))
    opt_analysis: dict = Opt(Dict("优化分析"))
    opt_curve: dict = Opt(Dict("优化曲线"))
    message: str = Opt(Str("提示"))


@dataclass
class DpResp(Model):
    self_use_ratio: float = Float("自发用比例").eg(70)
    rmb_per_wp: float = Float("单价").eg(7.5)
    sel_use_per_kwh: float = Float("电价").eg(0.8)
    self_use_price_discout: float = Float("电价折扣").eg(10)
    first_install_subsidy: float = Float("初装补贴").eg(0)
    local_subsidy: float = Float("地方补贴").eg(0.25)
    local_subsidy_year: float = Float("地方补贴年限").eg(5)


@dataclass
class DpaReq(Model):
    inline_id: int = Int("进线id").eg(17)
    install_space: float = Float("场区面积").eg(100)
    self_use_ratio: float = Float("自发用比例").eg(70)
    rmb_per_wp: float = Float("单价").eg(7.5)
    sel_use_per_kwh: float = Float("电价").eg(0.8)
    self_use_price_discout: float = Float("电价折扣").eg(10)
    first_install_subsidy: float = Float("初装补贴").eg(0)
    local_subsidy: float = Float("地方补贴").eg(0.25)
    local_subsidy_year: float = Float("地方补贴年限").eg(5)


@dataclass
class DpaResp(Model):
    install_cap: dict = Opt(Dict("接入规模"))
    invest_evaluate: dict = Opt(Dict("投资测算"))
    opt_analysis: dict = Opt(Dict("优化分析"))
    capacity_scale_chart: dict = Opt(Dict("优化曲线"))
    message: str = Opt(Str("提示"))
