import requests
import json
from pot_libs.aredis_util import aredis_utils


async def get_co2_price():
    url = "http://ets.cnemission.com/carbon/portalIndex/getRealTimeMarket?reportName=portalMarketRealTime"
    try:
        html = requests.get(url)
        data = json.loads(html.text)
        co2_price = float(data[0].get("CURRENT_PRICE")[:-1])
        await aredis_utils.RedisUtils().set("co2_price", co2_price)
    except:
        co2_price = await aredis_utils.RedisUtils().get("co2_price")
    return co2_price or 0
