from unify_api.modules.common.components.list_points_cps import LsRep, \
    LtpRep, LplResp, LpiResp
from unify_api.modules.common.dao.common_dao import storey_by_cid, \
    tsp_by_cid, monitor_point_join, inline_zdu_all_by_cid
from unify_api.modules.common.dao.level_dao import transformer_by_cid, \
    feeder_by_cid, power_dist_by_cid, inline_zdu_by_cid, device_level_by_cid
from unify_api.modules.common.procedures.list_point_pds import \
    monitor_map_point_location


async def list_storey_service(cid):
    """获取楼层-识电u"""
    storey_list = await storey_by_cid(cid)
    # 根据storey_name排序
    storeys = []
    for storey in storey_list:
        storey_id = storey["storey_id"]
        storey_id_list = [i["storey_id"] for i in storeys]
        if storey_id not in storey_id_list:
            storeys.append({
                "storey_id": storey_id,
                "storey_name": storey["storey_name"]
            })
    return LsRep(storeys)


async def list_tsp_point_service(cid):
    """获取TSP监测点-扬尘"""
    tsp_list = await tsp_by_cid(cid)
    return LtpRep(tsp_list)


async def list_point_level_service(cid):
    """新版监测点-包含进线变压器层级"""
    # 1.构造cid下每个monitor包含的point和location
    monitor_p_dic, monitor_l_dic = await monitor_map_point_location(cid)
    # 1. 进线
    inline_zdu_list = await inline_zdu_by_cid(cid)
    inline_res = [{"name": inline["m2.name"],
                   "id": inline["inlid"],
                   "point_id": monitor_p_dic.get(inline["mtid"]),
                   "location_id": monitor_l_dic.get(inline["mtid"]) or []}
                  for inline in inline_zdu_list]
    # 2. 变压器
    transformer_list = await transformer_by_cid(cid)
    transformer_res = [{"name": t["m2.name"],
                        "id": t["transf_id"],
                        "point_id": monitor_p_dic.get(t["mtid"]),
                        "location_id": monitor_l_dic.get(t["mtid"]) or []}
                       for t in transformer_list]
    # 3. 馈线
    feeder_list = await feeder_by_cid(cid)
    feeder_res = [{"name": f["m2.name"],
                   "id": f["feeder_id"],
                   "point_id": monitor_p_dic.get(f["mtid"]),
                   "location_id": monitor_l_dic.get(f["mtid"]) or []}
                  for f in feeder_list]
    # 4. 配电
    power_dist_list = await power_dist_by_cid(cid)
    power_dist_res = [{"name": p["m2.name"],
                       "id": p["power_dist_id"],
                       "point_id": monitor_p_dic.get(p["mtid"]),
                       "location_id": monitor_l_dic.get(p["mtid"]) or []}
                      for p in power_dist_list]
    # 5. 设备级
    device_list = await device_level_by_cid(cid)
    device_res = [{"name": d["m2.name"],
                   "id": d["dev_lv_id"],
                   "point_id": monitor_p_dic.get(d["mtid"]),
                   "location_id": monitor_l_dic.get(d["mtid"]) or []}
                  for d in device_list]

    monitor_point_list = await monitor_point_join(cid)
    return LplResp(
        inline=inline_res,
        transformer=transformer_res,
        feeder=feeder_res,
        power_dist=power_dist_res,
        device=device_res,
        power_show_all=1 if any(
            i for i in monitor_point_list if i["add_to_company"] == 1) else 0
    )


async def list_point_inline_service(cid):
    """新版监测点-进线"""
    inline_zdu_dic = await inline_zdu_all_by_cid(cid)
    inlines = [{"name": inline["name"], "inline_id": inline["inlid"]} for
               inline in inline_zdu_dic]
    return LpiResp(inlines=inlines)
