from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Int, Opt, List, Float, Dict


@dataclass
class SduAlarmReq(Model):
    cid: int = Int("cid").eg(1)
    start: str = Str("开始时间").eg("2023-02-01 00:00:00")
    end: str = Str("结束时间").eg("2023-02-28 23:59:59")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class RiskCount(Model):
    security_user: int = Opt(Int("安全用户").eg(10))
    risk_user: int = Opt(Int("风险用户").eg(2))


@dataclass
class ContentName(Model):
    ele_overload: int = Opt(Int("用电超载").eg(10))
    high_power_app: int = Opt(Int("大功率电器").eg(2))
    illegal_ele_app: int = Opt(Int("违规电器").eg(2))
    power_quality: int = Opt(Int("电能质量").eg(2))
    ele_car_battery: int = Opt(Int("电能质量").eg(2))


@dataclass
class SlotValue(Model):
    slots: list = List("slots").eg(["00-01", "00-02", "00-03"])
    value: list = List("时间段对应的值").eg([1, 2, 3])


@dataclass
class SduAlarmResp(Model):
    total_alarm_cnt: int = Int("总报警数").eg(12)
    alarm_points_cnt: int = Opt(Int("报警户数").eg(12))
    aver_alarm: float = Opt(Float("平均报警").eg(2.1))
    risk_distribution: RiskCount = Opt(RiskCount)
    content_distribution: ContentName = Opt(ContentName)
    alarm_ranking: list = Opt(List("报警排名").eg([{"name": "某房间", "value": 10}]))
    high_power_app: SlotValue = Opt(SlotValue)
    ele_overload: SlotValue = Opt(SlotValue)
    illegal_ele_app: SlotValue = Opt(SlotValue)
    power_quality: SlotValue = Opt(SlotValue)
    ele_car_battery: SlotValue = Opt(SlotValue)
    illegal_app_list: list = Opt(
        List("违规电器统计").eg([{"name": "热得快", "value": 4}])
    )


@dataclass
class NlaReq(Model):
    cid: Cid
    storeys: list = List("楼层列表").eg([1, 2, 3])
    importance: list = List("报警等级,默认:[1, 2, 3]").eg([1, 2, 3])

    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)
    start: str = Opt(Str("开始时间").eg("2020-05-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-03-10 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)
    point_ids: list = Opt(List("房间检测点").eg([1, 3, 4]))


@dataclass
class WlaReq(Model):
    cids: list = List("cid列表").eg([78, 83])
    start: str = Opt(Str("开始时间").eg("2020-05-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-03-10 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SasReq(Model):
    cids: list = List("cid列表").eg([78, 113])
    start: str = Str("开始时间").eg("2021-02-01 00:00:00")
    end: str = Str("结束时间").eg("2021-02-28 23:59:59")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SassReq(Model):
    cid: Cid
    page_size: int = Int("每页记录数").eg(10)
    page_num: int = Int("当前页码").eg(1)
    sort: str = Str("desc: 降序, asc: 升序").eg("desc")
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SassResp(Model):
    alarm_ranking_total: int = Int('报警记录总量')
    ele_app_ranking: list = List("电器识别").eg([{"name": "热得快", "value": 10}])
    alarm_ranking: list = List("报警记录排名").eg([{"name": "某房间", "value": 10}])


@dataclass
class AppReq(Model):
    cid: Cid
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class AppResp(Model):
    ele_app_ranking: list = List("电器识别").eg([{"name": "热得快", "value": 10}])


@dataclass
class SisReq(Model):
    cid: Cid
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SisResp(Model):
    ele_overload: dict = Dict("线路过载").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})
    illegal_ele_app: dict = Dict("违规电器").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})
    power_quality: dict = Dict("电能质量").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})


@dataclass
class SiasReq(Model):
    cid: Cid
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SiasResp(Model):
    risk_distribution: RiskCount = Opt(RiskCount)
    content_distribution: ContentName = Opt(ContentName)
    electric_use_score: float = Opt(Float("用电安全指数").eg(90.3))


@dataclass
class SebReq(Model):
    cid: Cid
    storeys: list = List("楼层列表").eg([1, 2, 3])
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class SebResp(Model):
    return_data: list = List("用电行为卡片数据").eg(
        [{"name": "89栋", "room_data": [
            {
                "room_name": "房间名",
                "illegal_ele_app": "违规",
                "high_power_app": "大功率",
                "normal_app": "正常",
                "alarm_score": "报警分"
            },
            {
                "room_name": "房间名",
                "illegal_ele_app": "违规",
                "high_power_app": "大功率",
                "normal_app": "正常",
                "alarm_score": "报警分"
            }
        ]}])


@dataclass
class SiarResp(Model):
    illegal_app: list = List("违规电器").eg(
        [{"name": "电动车电池", "value": 2}, {"name": "热得快", "value": 1}])
    illegal_behavior: list = List("违规行为").eg(
        [{"name": "104室", "value": 6}, {"name": "105室", "value": 1}])
    alarm_ranking: list = List("报警排名").eg(
        [{"name": "104室", "value": 2}, {"name": "105室", "value": 1}])


@dataclass
class LazReq(Model):
    cid: Cid
    point_list: list = List().eg([439, 440])
    importance: list = List("报警等级,默认:[1, 2, 3]").eg([1, 2, 3])
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)
    start: str = Opt(Str("开始时间").eg("2020-05-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-03-10 23:59:59"))
    event_type: list = List("内容筛选").eg(["overTempRange1min", "overTHDU"])
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(6)


@dataclass
class TimeCount(Model):
    daytime_cnt: int = Opt(Int("日间").eg(10))
    night_cnt: int = Opt(Int("夜间").eg(10))
    morning_cnt: int = Opt(Int("凌晨").eg(10))


@dataclass
class ZsResp(Model):
    total_alarm_cnt: int = Int("报警总数").eg(12)
    alarm_points_cnt: int = Opt(Int("报警监测点").eg(10))
    aver_alarm: float = Opt(Float("平均报警").eg(2.1))
    safe_run: float = Opt(Float("安全运行").eg(15))
    time_interval_distribution: TimeCount = Opt(TimeCount)


@dataclass
class ZasReq(Model):
    cid: Cid
    page_size: int = Int("每页记录数").eg(10)
    page_num: int = Int("当前页码").eg(1)
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(6)


@dataclass
class ZasResp(Model):
    total: int = Int('报警记录总量')
    alarm_ranking: list = List("报警排名").eg([{"name": "某房间", "value": 10}])
